/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.event.EventHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DogArrow
extends AbstractArrow {
    private static final int NULL_COLOR = -1;
    private PotionContents potionContents = PotionContents.EMPTY;
    private static final EntityDataAccessor<Integer> EFFECT_COLOR = SynchedEntityData.m_135353_(DogArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SPECTRAL = SynchedEntityData.m_135353_(DogArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Optional<UUID> dogOwnerUUID = Optional.empty();

    public DogArrow(EntityType<DogArrow> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_);
    }

    public DogArrow(Level p_36861_, AbstractDog dog, ItemStack stack) {
        super(DoggyEntityTypes.DOG_ARROW_PROJ.get(), (LivingEntity)dog, p_36861_);
        LivingEntity owner;
        this.setEffectsFromItem_1_20_1_and_under(stack);
        this.updateColor();
        if (stack.m_150930_(Items.f_42737_)) {
            this.f_19804_.m_135381_(IS_SPECTRAL, (Object)true);
        }
        if ((owner = dog.m_269323_()) != null) {
            this.dogOwnerUUID = Optional.ofNullable(owner.m_20148_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EFFECT_COLOR, (Object)-1);
        this.f_19804_.m_135372_(IS_SPECTRAL, (Object)false);
    }

    private PotionContents getPotionContents() {
        return this.potionContents;
    }

    private boolean hasPotionContents() {
        PotionContents data = this.getPotionContents();
        return data != PotionContents.EMPTY;
    }

    private void clearPotionContents() {
        this.potionContents = PotionContents.EMPTY;
    }

    private void updateColor() {
        int update_color = -1;
        if (this.hasPotionContents()) {
            update_color = this.getPotionContents().getColor();
        }
        this.f_19804_.m_135381_(EFFECT_COLOR, (Object)update_color);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isDogSpectralArrow()) {
            this.updateSpectralArrow();
        } else if (this.m_9236_().f_46443_) {
            this.makeClientArrowParticle();
        } else {
            this.updateEffectTimeout();
        }
    }

    private void makeClientArrowParticle() {
        int color = this.getColor();
        if (this.f_36703_) {
            if (this.f_36704_ % 5 == 0) {
                this.makeParticle(1, color);
            }
        } else {
            this.makeParticle(2, color);
        }
    }

    private void updateEffectTimeout() {
        boolean effect_expired;
        boolean bl = effect_expired = this.f_36703_ && this.f_36704_ >= 600 && this.hasPotionContents();
        if (effect_expired) {
            this.clearPotionContents();
        }
    }

    private void updateSpectralArrow() {
        if (this.m_9236_().f_46443_ && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void makeParticle(int amount, int color) {
        if (color == -1 || amount <= 0) {
            return;
        }
        double r = (double)(color >> 16 & 0xFF) / 255.0;
        double g = (double)(color >> 8 & 0xFF) / 255.0;
        double b = (double)(color >> 0 & 0xFF) / 255.0;
        for (int i = 0; i < amount; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), r, g, b);
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(EFFECT_COLOR);
    }

    public boolean isDogSpectralArrow() {
        return (Boolean)this.f_19804_.m_135370_(IS_SPECTRAL);
    }

    protected void m_7761_(LivingEntity target) {
        super.m_7761_(target);
        if (this.isDogSpectralArrow()) {
            this.doDogSpectralArrowEffectHurt(target);
        } else {
            this.doNormalDogArrowEffectHurt(target);
        }
        this.killCreeperIfCreeperSweeper(target);
    }

    private void doNormalDogArrowEffectHurt(LivingEntity target) {
        Entity effect_source = this.m_150173_();
        PotionContents potion_contents = this.getPotionContents();
        if (potion_contents.potion.isPresent()) {
            for (MobEffectInstance effect_inst : potion_contents.potion.get().m_43488_()) {
                target.m_147207_(new MobEffectInstance(effect_inst.m_19544_(), Math.max(effect_inst.m_267696_(x -> x / 8), 1), effect_inst.m_19564_(), effect_inst.m_19571_(), effect_inst.m_19572_()), effect_source);
            }
        }
        for (MobEffectInstance custom_effect_inst : potion_contents.customEffects()) {
            target.m_147207_(custom_effect_inst, effect_source);
        }
    }

    private void doDogSpectralArrowEffectHurt(LivingEntity target) {
        MobEffectInstance glow_inst = new MobEffectInstance(MobEffects.f_19619_, 200, 0);
        target.m_147207_(glow_inst, this.m_150173_());
    }

    private void killCreeperIfCreeperSweeper(LivingEntity target) {
        Entity owner = this.m_19749_();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel((Supplier)DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)target;
        creeper.m_21153_(0.0f);
        creeper.m_6667_(dog.m_269291_().m_269333_((LivingEntity)dog));
    }

    protected ItemStack m_7941_() {
        return this.getPickupItem_1_20_1_under();
    }

    protected boolean m_5603_(Entity target) {
        LivingEntity living;
        if (target instanceof LivingEntity && this.checkAlliesToDog(living = (LivingEntity)target)) {
            return false;
        }
        return super.m_5603_(target);
    }

    private boolean checkAlliesToDog(LivingEntity target) {
        Entity owner = this.m_19749_();
        if (!(owner instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)owner;
        LivingEntity dog_owner = dog.m_269323_();
        if (dog_owner == null) {
            return false;
        }
        return EventHandler.isAlliedToDog(target, dog_owner);
    }

    protected boolean m_142470_(Player picker) {
        if (this.shouldDogArrowBlockPickup(picker)) {
            return false;
        }
        return super.m_142470_(picker);
    }

    private boolean shouldDogArrowBlockPickup(Player picker) {
        if (picker.m_7500_()) {
            return false;
        }
        if (!this.dogOwnerUUID.isPresent()) {
            return false;
        }
        return !this.dogOwnerUUID.get().equals(picker.m_20148_());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.dogOwnerUUID.ifPresent(x -> tag.m_128362_("dtn_dog_owner_id", x));
        this.add_1_20_under_PotionData(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("dtn_dog_owner_id")) {
            UUID uuid = tag.m_128342_("dtn_dog_owner_id");
            this.dogOwnerUUID = Optional.ofNullable(uuid);
        }
        this.read1_20_under_PotionData(tag);
    }

    public void setEffectsFromItem_1_20_1_and_under(ItemStack stack) {
        if (stack.m_150930_(Items.f_42738_)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List customEffectsList = PotionUtils.m_43571_((ItemStack)stack);
            HashSet<MobEffectInstance> customEffectSet = null;
            if (!customEffectsList.isEmpty()) {
                customEffectSet = new HashSet<MobEffectInstance>(customEffectsList.size());
                for (MobEffectInstance effectInst : customEffectsList) {
                    customEffectSet.add(new MobEffectInstance(effectInst));
                }
            }
            this.potionContents = PotionContents.from(potion, customEffectSet);
        } else {
            this.potionContents = PotionContents.EMPTY;
        }
        this.updateColor();
    }

    private void read1_20_under_PotionData(CompoundTag compound) {
        Potion potion = null;
        if (compound.m_128425_("Potion", 8)) {
            potion = PotionUtils.m_43577_((CompoundTag)compound);
        }
        HashSet<MobEffectInstance> custom_set = new HashSet<MobEffectInstance>();
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)compound)) {
            custom_set.add(mobeffectinstance);
        }
        this.potionContents = PotionContents.from(potion, custom_set);
        this.updateColor();
    }

    public void add_1_20_under_PotionData(CompoundTag compound) {
        if (this.potionContents.potion.isPresent()) {
            Potion potion = this.potionContents.potion.get();
            compound.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
        }
        if (this.potionContents.customEffects.isPresent()) {
            Set<MobEffectInstance> customEffects = this.potionContents.customEffects.get();
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : customEffects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    private ItemStack getPickupItem_1_20_1_under() {
        if (this.potionContents == PotionContents.EMPTY) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack stack = new ItemStack((ItemLike)Items.f_42738_);
        this.potionContents.potion.ifPresent(x -> PotionUtils.m_43549_((ItemStack)stack, (Potion)x));
        this.potionContents.customEffects.ifPresent(x -> PotionUtils.m_43552_((ItemStack)stack, (Collection)x));
        return stack;
    }

    private static class PotionContents {
        public final Optional<Potion> potion;
        public final Optional<Set<MobEffectInstance>> customEffects;
        public final int color;
        public static PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty());

        private PotionContents(Optional<Potion> potion, Optional<Set<MobEffectInstance>> customEffects) {
            this.potion = potion;
            this.customEffects = customEffects;
            this.color = this.initColor();
        }

        public static PotionContents from(Potion potion, Set<MobEffectInstance> custom) {
            boolean empty_condition;
            boolean bl = empty_condition = !(potion != null && potion != Potions.f_43598_ || custom != null && !custom.isEmpty());
            if (empty_condition) {
                return EMPTY;
            }
            if (potion == null) {
                potion = Potions.f_43598_;
            }
            if (custom == null) {
                custom = Set.of();
            }
            return new PotionContents(Optional.of(potion), Optional.of(custom));
        }

        public int initColor() {
            if (!this.potion.isPresent() && !this.customEffects.isPresent()) {
                return -1;
            }
            return PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion.get(), (Collection)this.customEffects.get()));
        }

        public int getColor() {
            return this.color;
        }

        public Set<MobEffectInstance> customEffects() {
            return this.customEffects.orElse(Set.of());
        }
    }
}

